package fordummies.dao;

import java.util.List;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import fordummies.domain.User;

@Repository
public class UserDAOImplNoTemplate implements UserDAO {


	private SessionFactory sessionFactory;
	
	@Autowired
	public void setSessionFactory(SessionFactory sessionFactory) {
		this.sessionFactory = sessionFactory;
	}

	@Override
	@Transactional
	public void saveUser(User user) {
		System.out.println("Uso la sessione per salvare");
		sessionFactory.getCurrentSession().save(user);
	}
	
	@Override
	public List<User> listUser() {
		sessionFactory.getCurrentSession().createQuery("from _User");
		return null;
	}

}
